/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.eventmon;

import com.ibm.hwmca.fw.eventmon.EventMonitor;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MonitorEditorBean
extends PanelBean
implements DataBean {
    private static final String TRACE_MASKT = "XLISTENT";
    private static final String TRACE_MASKF = "XLISTENF";
    private static final String TRACE_MASKD = "XLISTEND";
    private static final String THIS_CLASS = "MonitorEditorBean";
    private String m_sMonitorName;
    private String m_sName;
    private String m_sMonitorDescription;
    private String[] m_sEventTypeSelection;
    private ItemDescriptor[][] m_idObjectSelection;
    private ColumnDescriptor[] m_cdObjectSelectionStructure;
    private int[] m_iObjectSelectionSelection;
    private String m_sTextFilter;
    private ValueDescriptor[] m_vdTextFilter;
    private boolean m_bLimitToTimes;
    private Calendar m_cStartTime;
    private Calendar m_cEndTime;
    private boolean m_bLimitToDays;
    private String[] m_sDaysSelection;
    private boolean m_bLimitToDates;
    private Calendar m_cStartDate;
    private Calendar m_cEndDate;
    private String m_sEmailAddress;
    private ValueDescriptor[] m_vdEmailAddress;
    private boolean _editing = false;
    private EventMonitor _selectedMonitor;
    private String[] _emailAddresses;
    private String[] _textFilters;
    private Map _objectMap;
    private Set _selectedObjectNames;
    private static final String[] UI_DAY_STRING_ARRAY = new String[]{"String6", "String9", "String10", "String11", "String8", "String15", "String16"};
    private static final List UI_DAY_STRING_LIST = Arrays.asList(UI_DAY_STRING_ARRAY);

    public void setMonitorName(String s) throws IllegalUserDataException {
        this.m_sMonitorName = s;
    }

    public String getMonitorName() {
        return this.m_sMonitorName;
    }

    public void setName(String s) throws IllegalUserDataException {
        this.m_sName = s;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setMonitorDescription(String s) throws IllegalUserDataException {
        this.m_sMonitorDescription = s;
    }

    public String getMonitorDescription() {
        return this.m_sMonitorDescription;
    }

    public void setEventTypeSelection(String[] selected) throws IllegalUserDataException {
        this.m_sEventTypeSelection = selected;
        Map titleMap = (Map)this._objectMap.get(selected[0]);
        Set titleSet = titleMap.keySet();
        TreeSet sortedTitleSet = new TreeSet();
        sortedTitleSet.addAll(titleSet);
        boolean buildRowSelectionArray = this._selectedMonitor != null && this._selectedMonitor.getItemNameInUI().equals(selected[0]);
        this.m_idObjectSelection = new ItemDescriptor[sortedTitleSet.size()][1];
        ArrayList<Integer> selectedRows = new ArrayList<Integer>();
        int count = 0;
        Iterator i = sortedTitleSet.iterator();
        String title = null;
        while (i.hasNext()) {
            title = (String)i.next();
            this.m_idObjectSelection[count][0] = new ItemDescriptor("object" + count, title);
            if (buildRowSelectionArray && this._selectedObjectNames.contains(title)) {
                selectedRows.add(new Integer(count));
            }
            ++count;
        }
        if (buildRowSelectionArray) {
            this.setObjectSelectionSelection(this.intArrayFromIntegerList(selectedRows));
        } else {
            int[] emptySelection = new int[]{};
            this.setObjectSelectionSelection(emptySelection);
        }
        this.getUserTaskManager().refreshAllElements();
    }

    private int[] intArrayFromIntegerList(List listOfIntegers) {
        int count = 0;
        int[] intArray = new int[listOfIntegers.size()];
        Iterator i = listOfIntegers.iterator();
        while (i.hasNext()) {
            intArray[count] = (Integer)i.next();
            ++count;
        }
        return intArray;
    }

    public String[] getEventTypeSelection() {
        return this.m_sEventTypeSelection;
    }

    public void setObjectSelectionSelection(int[] selected) throws IllegalUserDataException {
        this.m_iObjectSelectionSelection = selected;
    }

    public int[] getObjectSelectionSelection() {
        return this.m_iObjectSelectionSelection;
    }

    public void setObjectSelectionRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idObjectSelection[index] = items;
    }

    public ItemDescriptor[] getObjectSelectionRowAt(int index) {
        return this.m_idObjectSelection[index];
    }

    public int getObjectSelectionRowCount() {
        return this.m_idObjectSelection.length;
    }

    public int getObjectSelectionRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getObjectSelectionRowStructure() {
        return this.m_cdObjectSelectionStructure;
    }

    public ValueDescriptor[] getTextFilterList() {
        if (this.m_vdTextFilter == null) {
            this.m_vdTextFilter = new ValueDescriptor[this._textFilters.length];
            int i = 0;
            while (i < this._textFilters.length) {
                this.m_vdTextFilter[i] = new ValueDescriptor("textFilter" + i, this._textFilters[i]);
                ++i;
            }
        }
        return this.m_vdTextFilter;
    }

    public void setTextFilter(String s) throws IllegalUserDataException {
        this.m_sTextFilter = s;
    }

    public String getTextFilter() {
        return this.m_sTextFilter;
    }

    public void setLimitToTimes(boolean b) throws IllegalUserDataException {
        if (b != this.m_bLimitToTimes) {
            this.m_bLimitToTimes = b;
            this.getUserTaskManager().setEnabled("StartTimeEdit", b);
            this.getUserTaskManager().setEnabled("EndTimeEdit", b);
        }
    }

    public boolean isLimitToTimes() {
        return this.m_bLimitToTimes;
    }

    public void setStartTime(Calendar c) throws IllegalUserDataException {
        this.m_cStartTime = c;
    }

    public Calendar getStartTime() {
        return this.m_cStartTime;
    }

    public void setEndTime(Calendar c) throws IllegalUserDataException {
        this.m_cEndTime = c;
    }

    public Calendar getEndTime() {
        return this.m_cEndTime;
    }

    public void setLimitToDays(boolean b) throws IllegalUserDataException {
        if (b != this.m_bLimitToDays) {
            this.m_bLimitToDays = b;
            this.getUserTaskManager().setEnabled("String6", b);
            this.getUserTaskManager().setEnabled("String8", b);
            this.getUserTaskManager().setEnabled("String9", b);
            this.getUserTaskManager().setEnabled("String10", b);
            this.getUserTaskManager().setEnabled("String11", b);
            this.getUserTaskManager().setEnabled("String15", b);
            this.getUserTaskManager().setEnabled("String16", b);
        }
    }

    public boolean isLimitToDays() {
        return this.m_bLimitToDays;
    }

    public void setDaysSelection(String[] selected) throws IllegalUserDataException {
        this.m_sDaysSelection = selected;
    }

    public String[] getDaysSelection() {
        return this.m_sDaysSelection;
    }

    public void setLimitToDates(boolean b) throws IllegalUserDataException {
        if (b != this.m_bLimitToDates) {
            this.m_bLimitToDates = b;
            this.getUserTaskManager().setEnabled("StartDateEdit", b);
            this.getUserTaskManager().setEnabled("EndDateEdit", b);
        }
    }

    public boolean isLimitToDates() {
        return this.m_bLimitToDates;
    }

    public void setStartDate(Calendar c) throws IllegalUserDataException {
        this.m_cStartDate = c;
    }

    public Calendar getStartDate() {
        return this.m_cStartDate;
    }

    public void setEndDate(Calendar c) throws IllegalUserDataException {
        this.m_cEndDate = c;
    }

    public Calendar getEndDate() {
        return this.m_cEndDate;
    }

    public ValueDescriptor[] getEmailAddressList() {
        if (this.m_vdEmailAddress == null) {
            this.m_vdEmailAddress = new ValueDescriptor[this._emailAddresses.length];
            int i = 0;
            while (i < this._emailAddresses.length) {
                this.m_vdEmailAddress[i] = new ValueDescriptor("emailAddress" + i, this._emailAddresses[i]);
                ++i;
            }
        }
        return this.m_vdEmailAddress;
    }

    public void setEmailAddress(String s) throws IllegalUserDataException {
        this.m_sEmailAddress = s;
    }

    public String getEmailAddress() {
        return this.m_sEmailAddress;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        this.m_cdObjectSelectionStructure = new ColumnDescriptor[0];
        this.m_iObjectSelectionSelection = new int[0];
    }

    public StringBuffer dump() {
        StringBuffer buff = new StringBuffer();
        EventMonitor.appendMember(buff, "m_sMonitorName", this.getMonitorName());
        EventMonitor.appendMember(buff, "m_sMonitorDescription", this.getMonitorDescription());
        EventMonitor.appendMember(buff, "m_sEventTypeSelection", this.getEventTypeSelection());
        EventMonitor.appendMember(buff, "m_sTextFilter", this.getTextFilter());
        EventMonitor.appendMember(buff, "m_bLimitToTimes", this.isLimitToTimes());
        EventMonitor.appendMember(buff, "m_cStartTime", this.getStartTime());
        EventMonitor.appendMember(buff, "m_cEndTime", this.getEndTime());
        EventMonitor.appendMember(buff, "m_bLimitToDays", this.isLimitToDays());
        EventMonitor.appendMember(buff, "m_sDaysSelection", this.getDaysSelection());
        EventMonitor.appendMember(buff, "m_bLimitToDates", this.isLimitToDates());
        EventMonitor.appendMember(buff, "m_cStartDate", this.getStartDate());
        EventMonitor.appendMember(buff, "m_cEndDate", this.getEndDate());
        EventMonitor.appendMember(buff, "m_sEmailAddress", this.getEmailAddress());
        return buff;
    }

    public void save() {
    }

    public void prepare() {
        if (this._selectedMonitor != null) {
            this.setLimitToDates(this._selectedMonitor.isLimitedToDates());
            this.setLimitToTimes(this._selectedMonitor.isLimitedToTimes());
            this.setLimitToDays(this._selectedMonitor.isLimitedToDays());
            String[] eventType = new String[]{this._selectedMonitor.getItemNameInUI()};
            this.setEventTypeSelection(eventType);
        } else {
            this.setLimitToDates(false);
            this.setLimitToTimes(false);
            this.setLimitToDays(false);
            String[] eventType = new String[]{"StateChangesItem"};
            this.setEventTypeSelection(eventType);
        }
        this.getUserTaskManager().setEnabled("MonitorNameEdit", !this._editing);
    }

    public void panelAction(TaskActionEvent event) {
        String originator = event.getElementName();
        if (originator.equals("CancelButton")) {
            this.dispose();
        } else {
            int i;
            PanelTaskletRequest req = new PanelTaskletRequest();
            req.setData("event", event);
            req.setData("name", this.m_sMonitorName);
            req.setData("description", this.m_sMonitorDescription);
            req.setData("type", this.getEventTypeSelection()[0]);
            String textFilter = this.getTextFilter();
            String emailAddress = this.getEmailAddress();
            req.setData("regex", textFilter);
            req.setData("email", emailAddress);
            req.setData("limitToTimes", new Boolean(this.isLimitToTimes()));
            if (this.isLimitToTimes()) {
                req.setData("startTime", this.getStartTime());
                req.setData("endTime", this.getEndTime());
            }
            req.setData("limitToDates", new Boolean(this.isLimitToDates()));
            if (this.isLimitToDates()) {
                req.setData("startDate", this.getStartDate());
                req.setData("endDate", this.getEndDate());
            }
            String[] day = this.getDaysSelection();
            req.setData("limitToDays", new Boolean(this.isLimitToDays()));
            if (this.isLimitToDays()) {
                String[] daysSelection = this.getDaysSelection();
                ArrayList<Integer> dayIndexList = new ArrayList<Integer>(daysSelection.length);
                i = 0;
                while (i < daysSelection.length) {
                    dayIndexList.add(new Integer(UI_DAY_STRING_LIST.indexOf(daysSelection[i])));
                    ++i;
                }
                req.setData("days", dayIndexList);
            }
            int[] selectedObjects = this.getObjectSelectionSelection();
            ArrayList<String> objectNames = new ArrayList<String>(selectedObjects.length);
            i = 0;
            while (i < selectedObjects.length) {
                objectNames.add(this.getObjectSelectionRowAt(selectedObjects[i])[0].getTitle());
                ++i;
            }
            req.setData("objectNames", objectNames);
            req.setData("objectMap", this._objectMap);
            req.setData("editing", new Boolean(this._editing));
            this.postTaskletRequest(req);
        }
    }

    public void setEditing(boolean setting) {
        this._editing = setting;
    }

    public void setSelectedMonitor(EventMonitor monitor) {
        this._selectedMonitor = monitor;
    }

    public void setEmailAddresses(String[] addresses) {
        this._emailAddresses = addresses;
    }

    public void setTextFilters(String[] filters) {
        this._textFilters = filters;
    }

    public void setSelectedObjectNames(Set objectNames) {
        this._selectedObjectNames = objectNames;
    }

    public void setDaysSelection(List days) {
        int count = 0;
        String[] daySelection = new String[days.size()];
        Iterator i = days.iterator();
        while (i.hasNext()) {
            daySelection[count] = UI_DAY_STRING_ARRAY[(Integer)i.next()];
            ++count;
        }
        this.setDaysSelection(daySelection);
    }

    public void setObjectMap(Map map) {
        this._objectMap = map;
    }
}

